@extends('admin.layouts.master')
@section('title', __('messages.coupon_usage_report'))

@section('content')
<div class="max-w-7xl mx-auto px-4 py-10">

    {{-- 🔰 Header --}}
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between mb-6 gap-4">
        <h1 class="text-xl sm:text-2xl font-bold text-gray-800">
            📊 {{ __('messages.coupon_usage_report') }}
        </h1>
        <x-admin.back-button :href="route('admin.coupons.index')" />
    </div>

    {{-- 📈 Usage Table --}}
    <div class="bg-white shadow-sm rounded-lg overflow-x-auto border">
        <table class="w-full text-sm text-left border-collapse whitespace-nowrap">
            <thead class="bg-gray-50 text-gray-700 uppercase text-xs border-b font-semibold">
                <tr>
                    <th class="px-5 py-3">{{ __('messages.code') }}</th>
                    <th class="px-5 py-3">{{ __('messages.author') }}</th>
                    <th class="px-5 py-3">{{ __('messages.type') }}</th>
                    <th class="px-5 py-3">{{ __('messages.used') }}</th>
                    <th class="px-5 py-3">{{ __('messages.limit') }}</th>
                    <th class="px-5 py-3">{{ __('messages.start_end') }}</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                @forelse($coupons as $coupon)
                <tr class="hover:bg-gray-50 transition">
                    <td class="px-5 py-3 font-medium text-gray-900">{{ $coupon->code }}</td>
                    <td class="px-5 py-3 text-gray-700">{{ $coupon->author?->name ?? __('messages.admin') }}</td>
                    <td class="px-5 py-3 capitalize">{{ $coupon->type }}</td>
                    <td class="px-5 py-3 text-green-600 font-semibold">{{ $coupon->used_count }}</td>
                    <td class="px-5 py-3">{{ $coupon->usage_limit ?? '∞' }}</td>
                    <td class="px-5 py-3 text-sm text-gray-600">
                        {{ $coupon->start_date->format('M d, Y') }} – {{ $coupon->end_date->format('M d, Y') }}
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-5 py-6 text-center text-gray-500 italic">
                        {{ __('messages.no_coupon_usage') }}
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
